//=====================================================================================
//
//	Author				:Cytron Technologies		
//	Project				:control pwm
//	Project description	:control PWM chip using PIC18F4520 
//
//=====================================================================================

#include<p18f4520.h>

//=====================================================================================
//	configuration bit
//=====================================================================================
#pragma config OSC = HSPLL
#pragma config FCMEN = OFF 
#pragma config IESO = OFF 
#pragma config PWRT = OFF 
#pragma config BOREN = OFF 
#pragma config WDT = OFF 
#pragma config MCLRE = ON	
#pragma config PBADEN = OFF 
#pragma config DEBUG = OFF
#pragma config XINST = OFF
#pragma config LVP = OFF 

//=====================================================================================
//	define input or ouput of board here
//	
//=====================================================================================

#define	button1		PORTBbits.RB0			//button 1 active low
#define	select1		LATBbits.LATB3			//led1 active high				
#define	select2		LATBbits.LATB2			//led2 active high				
#define	select3		LATBbits.LATB1			//led3 active high
#define reset		LATBbits.LATB7			//reset of PWM chip, 0=reset, normally high

//=====================================================================================
//	function prototype
//=====================================================================================
void ISRHigh(void);
void ISRLow(void);
void delay(unsigned long data);
void init(void);
void uart(void);
unsigned char read_serial(void);
void send_serial(unsigned char data);
void send_str(const char *s);
void UART115200(void);		

//=====================================================================================
//	Global Variable
//=====================================================================================

//=====================================================================================
// protocol for data send to PWM chip
//=====================================================================================
// data1 = channel of PWM (0x00 - 0x0d)
// data2 = value of PWM (0x00-0xff OR 0-255)

//=====================================================================================
//	Main Function
//	This is the main function where program start to execute 
//=====================================================================================

void main(void)
{	
	
	init();					// call initialization function of the setting in program

	while(1)
	{	
	
		if(button1==0)					//button 1 to switch mode between play and record
		{
			while(button1==0);			//wait button 1 to release			
			reset = 0;
			delay(5000);
			reset = 1;
			UART115200();					// set UART 115200			
			select1 = 0;
			select2 = 1;
			select3 = 0;
			delay(10);					//delay 29us for the PWM chip to switch to selected mode
			uart();						// send UART data
		
		}
	}
	
}

//=====================================================================================
//	functions
//  User can write all the necessary function here
//=====================================================================================
//read uart data
unsigned char read_serial(void)
{
	unsigned char temp;
	while(PIR1bits.RCIF==0);
	temp=RCREG;
	return temp;
}

//send uart data
void send_serial(unsigned char data)
{
	while (PIR1bits.TXIF == 0);
	TXREG = data;	
}

void send_str(const char *s)
{          
	unsigned char i=0;
  	while (s && *s)send_serial (*s++);

}

void delay(unsigned long data)
{
	for( ;data>0;data-=1);
}

void UART115200(void)
{
	unsigned char temp;

	//initialize uart	
	TRISCbits.TRISC6=1;					//TX
	TRISCbits.TRISC7=1;					//RX
	
	SPBRG=21;	//115200,SPBRG = Fosc/(16*baud) - 1, Fosc = 32M, [8M,3][32M,16][10M,4.4]

	TXSTAbits.TX9=0;		//8/9-bit transmission, 0 = 8bit, 1=9bit
	TXSTAbits.TXEN=1;		//disable/enable transmit
	TXSTAbits.SYNC=0;		//asynchronous/synchronous mode, 0 =asyn
	TXSTAbits.BRGH=1;		//low/high speed, 1 = high speed,0, SPBRG=Fosc/(64*baud)-1, 9600=15.27, 57600=1.7

	RCSTAbits.SPEN=1;		//serial port disable/enable
	RCSTAbits.RX9=0;		//8/9-bit reception, 0 =8bit
	RCSTAbits.CREN=1;		//continuous receive disable/enable

	BAUDCON = 0b00000000;	//BAUD RATE CONTROL REGISTER
	temp=RCREG;				//clear receive buffer
	temp=RCREG;

	PIR1bits.RCIF=0;		//clear interrupt flag
	PIE1bits.RCIE=0;		//disable/enable receive interrupt
	IPR1bits.RCIP=0;		//low/high priority interrupt
	
}


void uart(void)
{
	unsigned char data1;

	send_serial(0x01);
	send_serial(0x7f);
	send_serial(0x02);
	send_serial(0x8f);
	send_serial(0x03);
	send_serial(0x9f);
	send_serial(0x04);
	send_serial(0xaf);
	send_serial(0x05);
	send_serial(0xbf);
	send_serial(0x06);
	send_serial(0xff);
	send_serial('r');
	send_serial(0x06);
	data1=read_serial();
	send_serial(0x07);
	send_serial(data1);
	send_serial(0x00);
	send_serial(data1);
	
}

void init(void)
{

	// this is a initialization for set the input and output of PIC18F4520
	// tris
	TRISB=0x01;				// portB as output, RB0 as input
	TRISD=0x00;				// portD as output
	TRISC=0xff;				// 
	
	select1 = 0;
	select2 = 0;
	select3 = 0;
	
}


//=====================================================================================
//	Interrupt vector
//=====================================================================================
#pragma	code InterruptVectorHigh = 0x08
void InterruptVectorHigh(void)
{
 	_asm
		goto ISRHigh		// jump to interrupt routine
	_endasm
}
#pragma code

#pragma	code InterruptVectorLow = 0x18
void InterruptVectorLow(void)
{
 	_asm
		goto ISRLow			// jump to interrupt routine
	_endasm
}
#pragma code

//=====================================================================================
//	Interupt Service Routine
//	this a function reserved for interrupt service routine
//=====================================================================================
#pragma interrupt ISRHigh
void ISRHigh(void)
{

	
}

#pragma interrupt ISRLow
void ISRLow(void)
{
	
}
